<?php

namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Company extends Model
{
    use SoftDeletes;

    protected $table = 'companies';

    protected $fillable = [
        'uuid',
        'name',
        'legal_name',
        'registration_no',
        'tax_id',
        'email',
        'phone',
        'website',
        'country',
        'state',
        'city',
        'address',
        'postal_code',
        'logo',
        'theme',
        'timezone',
        'date_format',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    public function branches(): HasMany
    {
        return $this->hasMany(CompanyBranch::class);
    }

    public function subscriptions(): HasMany
    {
        return $this->hasMany(CompanySubscription::class);
    }

    public function limits(): HasMany
    {
        return $this->hasMany(CompanyLimit::class);
    }

    public function modules(): HasMany
    {
        return $this->hasMany(CompanyModule::class);
    }

    public function billingHistory(): HasMany
    {
        return $this->hasMany(CompanyBillingHistory::class);
    }

    public function customServices(): HasMany
    {
        return $this->hasMany(CompanyCustomService::class);
    }

    public function auditLogs(): HasMany
    {
        return $this->hasMany(CompanyAuditLog::class);
    }

    public function taxSettings(): HasMany
    {
        return $this->hasMany(CompanyTaxSetting::class);
    }
}
