<?php

namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CompanyBranch extends Model
{
    use SoftDeletes;

    protected $table = 'company_branches';

    protected $fillable = [
        'uuid',
        'company_id',
        'name',
        'code',
        'type',
        'country',
        'state',
        'city',
        'address',
        'latitude',
        'longitude',
        'is_active',
        'is_sync_allowed',
    ];

    protected $casts = [
        'is_active' => 'boolean',
        'is_sync_allowed' => 'boolean',
        'latitude' => 'float',
        'longitude' => 'float',
    ];

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }
}
