<?php

namespace App\Core\Providers;

use Illuminate\Support\ServiceProvider;

class CoreServiceProvider extends ServiceProvider
{
    public function register()
    {
        // You can bind your interfaces/services here
    }

    public function boot()
    {
        // ✅ Load only Core-specific migrations
        $coreMigrationPath = __DIR__ . '/../Database/Migrations';
        if (is_dir($coreMigrationPath)) {
            $this->loadMigrationsFrom($coreMigrationPath);
        }

       // ✅ Optional: load API routes only
        $apiRoutes = __DIR__ . '/../Routes/api.php';
        if (file_exists($apiRoutes)) {
            $this->loadRoutesFrom($apiRoutes);
        }

        // (Skip loading web.php unless you need it)
    }
}
