<?php
// ============================================================================
// app/Core/Models/Role.php
// ============================================================================
namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

class Role extends Model
{
    protected $table = 'user_roles';

    protected $fillable = [
        'name',
        'company_id',
    ];

    public function permissions(): BelongsToMany
    {
        return $this->belongsToMany(
            Permission::class,
            'user_role_permissions',
            'role_id',
            'permission_id'
        );
    }
}
