<?php
// ============================================================================
// app/Core/Models/UserCompany.php
// ============================================================================
namespace App\Core\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class UserCompany extends Model
{
    protected $table = 'user_companies';

    protected $fillable = [
        'user_id',
        'company_id',
        'branch_id',
        'role_type',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
