<?php

namespace App\Modules\Analytics\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class AnalyticsController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Analytics module is working']);
    }

    // List all reports (sample data)
    public function index()
    {
        $reports = [
            ['id' => 1, 'name' => 'Sales Report', 'type' => 'Monthly'],
            ['id' => 2, 'name' => 'Expense Report', 'type' => 'Monthly'],
        ];

        return response()->json($reports);
    }

    // Show single report
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Sample Report',
            'type' => 'Custom',
            'data' => []
        ]);
    }

    // Create report
    public function store(Request $request)
    {
        $data = $request->only(['name', 'type', 'data']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Report created', 'report' => $data], 201);
    }

    // Update report
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'type', 'data']);
        return response()->json(['message' => "Report {$id} updated", 'report' => $data]);
    }

    // Delete report
    public function destroy($id)
    {
        return response()->json(['message' => "Report {$id} deleted"]);
    }
}
