<?php

namespace App\Modules\Billing\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class BillingController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Billing module is working']);
    }

    // List all invoices (sample data)
    public function index()
    {
        $invoices = [
            ['id' => 1, 'customer' => 'John Doe', 'amount' => 250.00, 'status' => 'paid'],
            ['id' => 2, 'customer' => 'Jane Smith', 'amount' => 150.00, 'status' => 'unpaid'],
        ];

        return response()->json($invoices);
    }

    // Show single invoice
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'customer' => 'Sample Customer',
            'amount' => 200.00,
            'status' => 'paid',
            'items' => [
                ['description' => 'Service A', 'amount' => 100],
                ['description' => 'Service B', 'amount' => 100]
            ]
        ]);
    }

    // Create invoice
    public function store(Request $request)
    {
        $data = $request->only(['customer', 'amount', 'status', 'items']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Invoice created', 'invoice' => $data], 201);
    }

    // Update invoice
    public function update(Request $request, $id)
    {
        $data = $request->only(['customer', 'amount', 'status', 'items']);
        return response()->json(['message' => "Invoice {$id} updated", 'invoice' => $data]);
    }

    // Delete invoice
    public function destroy($id)
    {
        return response()->json(['message' => "Invoice {$id} deleted"]);
    }
}
