<?php

namespace App\Modules\Currency\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class CurrencyController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Currency module is working']);
    }

    // List all currencies (sample data)
    public function index()
    {
        $currencies = [
            ['code' => 'USD', 'name' => 'US Dollar', 'symbol' => '$', 'rate_to_usd' => 1],
            ['code' => 'EUR', 'name' => 'Euro', 'symbol' => '€', 'rate_to_usd' => 1.1],
            ['code' => 'GBP', 'name' => 'British Pound', 'symbol' => '£', 'rate_to_usd' => 1.3],
        ];

        return response()->json($currencies);
    }

    // Show single currency
    public function show($code)
    {
        return response()->json([
            'code' => $code,
            'name' => 'Sample Currency',
            'symbol' => '$',
            'rate_to_usd' => 1.0
        ]);
    }

    // Add currency
    public function store(Request $request)
    {
        $data = $request->only(['code', 'name', 'symbol', 'rate_to_usd']);
        return response()->json(['message' => 'Currency added', 'currency' => $data], 201);
    }

    // Update currency
    public function update(Request $request, $code)
    {
        $data = $request->only(['name', 'symbol', 'rate_to_usd']);
        return response()->json(['message' => "Currency {$code} updated", 'currency' => $data]);
    }

    // Delete currency
    public function destroy($code)
    {
        return response()->json(['message' => "Currency {$code} deleted"]);
    }
}
