<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Currency\Http\Controllers\CurrencyController;

Route::prefix('currency')->group(function () {
    Route::get('/test', [CurrencyController::class, 'test']); // test route
    Route::get('/all', [CurrencyController::class, 'index']); // list all currencies
    Route::get('/{code}', [CurrencyController::class, 'show']); // show single currency
    Route::post('/', [CurrencyController::class, 'store']); // add currency
    Route::put('/{code}', [CurrencyController::class, 'update']); // update currency
    Route::delete('/{code}', [CurrencyController::class, 'destroy']); // delete currency
});
