<?php

use Illuminate\Support\Facades\Route;
use App\Modules\Integration\Http\Controllers\IntegrationController;

Route::prefix('integration')->group(function () {
    Route::get('/test', [IntegrationController::class, 'test']); // test route
    Route::get('/services', [IntegrationController::class, 'index']); // list all integrations
    Route::get('/services/{id}', [IntegrationController::class, 'show']); // show single integration
    Route::post('/services', [IntegrationController::class, 'store']); // add integration
    Route::put('/services/{id}', [IntegrationController::class, 'update']); // update integration
    Route::delete('/services/{id}', [IntegrationController::class, 'destroy']); // delete integration
});
