<?php

namespace App\Core\Models\Product;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = 'products';

    protected $fillable = [
        'uuid',
        'company_id',
        'branch_id',
        'name',
        'sku',
        'type',
        'category_id',
        'brand_id',
        'unit_id',
        'is_serialized',
        'is_expirable',
        'cost_price',
        'sale_price',
        'attributes',
    ];

    protected $casts = [
        'attributes' => 'array',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }

    public function attributeValues()
    {
        return $this->hasMany(ProductAttributeValue::class);
    }

    public function serials()
    {
        return $this->hasMany(ProductSerial::class);
    }

    public function stock()
    {
        return $this->hasMany(InventoryStock::class);
    }

    public function movements()
    {
        return $this->hasMany(StockMovement::class);
    }
}
