<?php

namespace App\Core\Models\Product;

use Illuminate\Database\Eloquent\Model;

class ProductSerial extends Model
{
    protected $table = 'product_serials';

    protected $fillable = [
        'uuid',
        'product_id',
        'company_id',
        'serial_number',
        'is_sold',
        'warranty_until',
    ];

    protected $casts = [
        'is_sold' => 'boolean',
        'warranty_until' => 'date',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
