<?php

namespace App\Core\Models\Product;

use Illuminate\Database\Eloquent\Model;

class StockMovement extends Model
{
    protected $table = 'stock_movements';

    protected $fillable = [
        'uuid',
        'product_id',
        'company_id',
        'branch_id',
        'type',
        'quantity',
        'cost_price',
        'meta',
    ];

    protected $casts = [
        'quantity' => 'decimal:2',
        'cost_price' => 'decimal:2',
        'meta' => 'array',
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
