<?php

namespace App\Modules\Language\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class LanguageController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Language module is working']);
    }

    // List all languages (sample data)
    public function index()
    {
        $languages = [
            ['id' => 1, 'name' => 'English', 'code' => 'en', 'status' => 'active'],
            ['id' => 2, 'name' => 'Spanish', 'code' => 'es', 'status' => 'inactive'],
        ];

        return response()->json($languages);
    }

    // Show single language
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'English',
            'code' => 'en',
            'status' => 'active',
            'translations' => [
                'hello' => 'Hello',
                'welcome' => 'Welcome',
            ]
        ]);
    }

    // Add new language
    public function store(Request $request)
    {
        $data = $request->only(['name', 'code', 'status', 'translations']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Language added', 'language' => $data], 201);
    }

    // Update language
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'code', 'status', 'translations']);
        return response()->json(['message' => "Language {$id} updated", 'language' => $data]);
    }

    // Delete language
    public function destroy($id)
    {
        return response()->json(['message' => "Language {$id} deleted"]);
    }
}
