<?php

namespace App\Modules\Manufacturing\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ManufacturingController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'Manufacturing module is working']);
    }

    // List all production orders (sample data)
    public function index()
    {
        $orders = [
            ['id' => 1, 'product' => 'Widget A', 'quantity' => 100, 'status' => 'in progress'],
            ['id' => 2, 'product' => 'Widget B', 'quantity' => 50, 'status' => 'completed'],
        ];

        return response()->json($orders);
    }

    // Show single production order
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'product' => 'Widget A',
            'quantity' => 100,
            'status' => 'in progress',
            'workstations' => [
                ['name' => 'Cutting', 'status' => 'completed'],
                ['name' => 'Assembly', 'status' => 'in progress'],
            ]
        ]);
    }

    // Create new production order
    public function store(Request $request)
    {
        $data = $request->only(['product', 'quantity', 'status', 'workstations']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Production order created', 'order' => $data], 201);
    }

    // Update production order
    public function update(Request $request, $id)
    {
        $data = $request->only(['product', 'quantity', 'status', 'workstations']);
        return response()->json(['message' => "Production order {$id} updated", 'order' => $data]);
    }

    // Delete production order
    public function destroy($id)
    {
        return response()->json(['message' => "Production order {$id} deleted"]);
    }
}
