<?php

namespace App\Modules\ProjectManagement\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class ProjectManagementController extends Controller
{
    // Test route
    public function test()
    {
        return response()->json(['message' => 'ProjectManagement module is working']);
    }

    // List all projects (sample data)
    public function index()
    {
        $projects = [
            ['id' => 1, 'name' => 'Website Redesign', 'status' => 'active', 'team' => ['Alice', 'Bob']],
            ['id' => 2, 'name' => 'Mobile App', 'status' => 'completed', 'team' => ['Charlie', 'David']],
        ];

        return response()->json($projects);
    }

    // Show single project
    public function show($id)
    {
        return response()->json([
            'id' => $id,
            'name' => 'Website Redesign',
            'status' => 'active',
            'team' => ['Alice', 'Bob'],
            'tasks' => [
                ['id' => 101, 'title' => 'Design UI', 'status' => 'completed'],
                ['id' => 102, 'title' => 'Develop Frontend', 'status' => 'in progress']
            ],
            'milestones' => [
                ['title' => 'Prototype', 'due_date' => '2025-12-01'],
                ['title' => 'Launch', 'due_date' => '2026-01-15']
            ]
        ]);
    }

    // Create new project
    public function store(Request $request)
    {
        $data = $request->only(['name', 'status', 'team', 'tasks', 'milestones']);
        $data['id'] = rand(100, 999); // sample ID
        return response()->json(['message' => 'Project created', 'project' => $data], 201);
    }

    // Update project
    public function update(Request $request, $id)
    {
        $data = $request->only(['name', 'status', 'team', 'tasks', 'milestones']);
        return response()->json(['message' => "Project {$id} updated", 'project' => $data]);
    }

    // Delete project
    public function destroy($id)
    {
        return response()->json(['message' => "Project {$id} deleted"]);
    }
}
