<?php

use Illuminate\Support\Facades\Route;
use App\Modules\RepairShop\Http\Controllers\RepairShopController;

Route::prefix('repair-shop')->group(function () {
    Route::get('/test', [RepairShopController::class, 'test']); // test route
    Route::get('/orders', [RepairShopController::class, 'index']); // list all repair orders
    Route::get('/orders/{id}', [RepairShopController::class, 'show']); // show single repair order
    Route::post('/orders', [RepairShopController::class, 'store']); // create new repair order
    Route::put('/orders/{id}', [RepairShopController::class, 'update']); // update repair order
    Route::delete('/orders/{id}', [RepairShopController::class, 'destroy']); // delete repair order
});
