<?php

namespace App\Modules\Security\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class SecurityController extends Controller
{
    public function index()
    {
        return response()->json([
            'status' => 'success',
            'settings' => [
                'password_policy' => 'strong',
                'two_factor_auth' => true
            ]
        ]);
    }

    public function update(Request $request)
    {
        // Example: Update security settings (you can expand this)
        $data = $request->only(['password_policy', 'two_factor_auth']);

        return response()->json([
            'status' => 'success',
            'message' => 'Security settings updated',
            'updated_settings' => $data
        ]);
    }

    public function test()
    {
        return response()->json(['message' => 'Security module is working!']);
    }
}
