<?php

namespace App\Modules\TenantManager\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class TenantManagerController extends Controller
{
    private $tenants = [
        ['id' => 1, 'name' => 'Tenant One', 'status' => 'active'],
        ['id' => 2, 'name' => 'Tenant Two', 'status' => 'inactive'],
    ];

    public function index()
    {
        return response()->json([
            'status' => 'success',
            'tenants' => $this->tenants
        ]);
    }

    public function addTenant(Request $request)
    {
        $data = $request->only(['name', 'status']);
        $data['id'] = count($this->tenants) + 1;
        $this->tenants[] = $data;

        return response()->json([
            'status' => 'success',
            'message' => 'Tenant added successfully',
            'tenant' => $data
        ]);
    }

    public function updateTenant(Request $request)
    {
        $data = $request->only(['id', 'name', 'status']);

        foreach ($this->tenants as &$tenant) {
            if ($tenant['id'] == $data['id']) {
                $tenant['name'] = $data['name'] ?? $tenant['name'];
                $tenant['status'] = $data['status'] ?? $tenant['status'];
            }
        }

        return response()->json([
            'status' => 'success',
            'message' => "Tenant ID {$data['id']} updated",
            'tenants' => $this->tenants
        ]);
    }

    public function test()
    {
        return response()->json(['message' => 'TenantManager module is working!']);
    }
}
