<?php

namespace App\Modules\UserProfile\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class UserProfileController extends Controller
{
    public function index()
    {
        return response()->json(['message' => 'List of users']);
    }

    public function show($id)
    {
        return response()->json(['message' => "Showing user {$id}"]);
    }

    public function store(Request $request)
    {
        return response()->json(['message' => 'User created', 'data' => $request->all()]);
    }

    public function update(Request $request, $id)
    {
        return response()->json(['message' => "User {$id} updated", 'data' => $request->all()]);
    }

    public function destroy($id)
    {
        return response()->json(['message' => "User {$id} deleted"]);
    }
}
