<?php

namespace App\Modules\UserProfile\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserSkill extends Model
{
    use HasFactory;

    protected $table = 'user_skills';

    protected $fillable = [
        'user_profile_id',
        'name',
        'level',
    ];

    // Relationship
    public function profile()
    {
        return $this->belongsTo(UserProfile::class);
    }
}
