<?php

use Illuminate\Support\Facades\Route;
use App\Modules\UserProfile\Http\Controllers\UserProfileController;

Route::prefix('user-profiles')->group(function () {
    Route::get('/', [UserProfileController::class, 'index']);
    Route::get('/{id}', [UserProfileController::class, 'show']);
    Route::post('/', [UserProfileController::class, 'store']);
    Route::put('/{id}', [UserProfileController::class, 'update']);
    Route::delete('/{id}', [UserProfileController::class, 'destroy']);
});
