<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        $prefix = 'repair_shop_';

        // ---------------------
        // Staff
        // ---------------------
        Schema::create($prefix.'staff', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // removed FK
            $table->string('position')->nullable();
            $table->string('phone')->nullable();
            $table->timestampsTz();
        });

        // ---------------------
        // Customers
        // ---------------------
        Schema::create($prefix.'customers', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // removed FK
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->timestampsTz();
        });

        // ---------------------
        // Vehicles
        // ---------------------
        Schema::create($prefix.'vehicles', function (Blueprint $table) use ($prefix) {
            $table->id();
            $table->unsignedBigInteger('customer_id'); // removed FK
            $table->string('make');
            $table->string('model');
            $table->string('year')->nullable();
            $table->string('vin')->unique()->nullable();
            $table->timestampsTz();
        });

        // ---------------------
        // Services
        // ---------------------
        Schema::create($prefix.'services', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('price',15,2)->default(0);
            $table->timestampsTz();
        });

        // ---------------------
        // Parts
        // ---------------------
        Schema::create($prefix.'parts', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('sku')->unique();
            $table->decimal('cost_price',15,2)->default(0);
            $table->decimal('sale_price',15,2)->default(0);
            $table->integer('stock_quantity')->default(0);
            $table->timestampsTz();
        });

        // ---------------------
        // Repairs (Main Job)
        // ---------------------
        Schema::create($prefix.'repairs', function (Blueprint $table) use ($prefix) {
            $table->id();
            $table->unsignedBigInteger('vehicle_id'); // removed FK
            $table->unsignedBigInteger('staff_id')->nullable(); // removed FK
            $table->text('description')->nullable();
            $table->enum('status', ['pending','in_progress','completed','cancelled'])->default('pending');
            $table->decimal('total_amount',15,2)->default(0);
            $table->decimal('total_paid',15,2)->default(0);
            $table->timestampsTz();
        });

        // ---------------------
        // Repair Services
        // ---------------------
        Schema::create($prefix.'repair_services', function (Blueprint $table) use ($prefix) {
            $table->id();
            $table->unsignedBigInteger('repair_id'); // removed FK
            $table->unsignedBigInteger('service_id'); // removed FK
            $table->decimal('price',15,2)->default(0);
            $table->timestampsTz();
        });

        // ---------------------
        // Repair Parts
        // ---------------------
        Schema::create($prefix.'repair_parts', function (Blueprint $table) use ($prefix) {
            $table->id();
            $table->unsignedBigInteger('repair_id'); // removed FK
            $table->unsignedBigInteger('part_id'); // removed FK
            $table->integer('quantity')->default(1);
            $table->decimal('price',15,2)->default(0);
            $table->timestampsTz();
        });

        // ---------------------
        // Invoices
        // ---------------------
        Schema::create($prefix.'invoices', function (Blueprint $table) use ($prefix) {
            $table->id();
            $table->unsignedBigInteger('repair_id'); // removed FK
            $table->string('invoice_number')->unique();
            $table->decimal('amount',15,2)->default(0);
            $table->enum('status', ['unpaid','paid','partial'])->default('unpaid');
            $table->timestampsTz();
        });

        // ---------------------
        // Payments
        // ---------------------
        Schema::create($prefix.'payments', function (Blueprint $table) use ($prefix) {
            $table->id();
            $table->unsignedBigInteger('invoice_id'); // removed FK
            $table->decimal('amount',15,2);
            $table->date('payment_date');
            $table->string('payment_method'); 
            $table->timestampsTz();
        });
    }

    public function down(): void
    {
        $prefix = 'repair_shop_';

        Schema::dropIfExists($prefix.'payments');
        Schema::dropIfExists($prefix.'invoices');
        Schema::dropIfExists($prefix.'repair_parts');
        Schema::dropIfExists($prefix.'repair_services');
        Schema::dropIfExists($prefix.'repairs');
        Schema::dropIfExists($prefix.'parts');
        Schema::dropIfExists($prefix.'services');
        Schema::dropIfExists($prefix.'vehicles');
        Schema::dropIfExists($prefix.'customers');
        Schema::dropIfExists($prefix.'staff');
    }
};
